<?php
/**
 * Plugin Name: Simple Currency Converter
 * Description: A full currency converter widget with all world currencies and live exchange rates. All in one file.
 * Version: 1.2
 * Author: Luvcite Technology...
 */

if (!defined('ABSPATH')) exit;

function scc_display_converter() {
    ob_start(); ?>

<style>
    .VmainContainer {
        width: max-content;
        border: 1px solid #aaa;
        padding: 10px;
        background: #fff;
        box-shadow: 0 0 4px rgba(0, 0, 0, 0.1);
        text-align: center;
        border-radius: 5px;
        font-family: Arial, sans-serif;
    }

    .Vlabel {
        font-weight: bold;
        color: #222;
        font-size: 13px;
    }

    .Vtextarea {
        width: 90%;
        padding: 5px;
        border: 1px solid #ccc;
        border-radius: 3px;
        text-align: right;
    }

    .VselectBox {
        width: 95%;
        padding: 4px;
        border: 1px solid #ccc;
        border-radius: 3px;
    }

    .Vspacer {
        height: 8px;
    }

    .Vmsg_1 {
        font-size: 11px;
        color: #555;
    }
</style>
<h2>
	CURRENCY COMPARISON
</h2>
<p>
	Use the CURRENCY COMPARISON tool to see price in your local currency. <br>
Please note that your credit card provider may use slightly different rates.
</p>
<div class="VmainContainer">
    <font class="Vlabel">Amount</font><br>
    <input class="Vtextarea" name="Vamount" id="Vamount" value="0">
    <div class="Vspacer"></div>

    <font class="Vlabel">FROM</font><br>
    <select name="Vfrom" id="Vfrom" class="VselectBox">
        <?php echo scc_currency_options('USD'); ?>
    </select>

    <div class="Vspacer"></div>
    <font class="Vlabel">TO</font><br>
    <select name="Vto" id="Vto" class="VselectBox">
        <?php echo scc_currency_options('EUR'); ?>
    </select>

    <div class="Vspacer"></div>
    <font class="Vlabel" id="Vresult_label">Result:</font><br>
    <textarea class="Vtextarea" cols="18" rows="1" name="Vresult" id="result" readonly>0.00</textarea>

    <div class="Vspacer"></div>
    <font class="Vmsg_1">Rates on <b>
            <?php echo date("j M Y"); ?>
        </b></font>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const amountInput = document.getElementById('Vamount');
        const fromSelect = document.getElementById('Vfrom');
        const toSelect = document.getElementById('Vto');
        const resultBox = document.getElementById('result');
        const label = document.getElementById('Vresult_label');

        function convert() {
            const from = fromSelect.value;
            const to = toSelect.value;
            let amount = parseFloat(amountInput.value);
            if (isNaN(amount)) amount = 0;

            fetch(`https://api.frankfurter.app/latest?amount=${amount}&from=${from}&to=${to}`)
                .then(res => res.json())
                .then(data => {
                    if (data.rates && Object.values(data.rates).length > 0) {
                        resultBox.value = Object.values(data.rates)[0].toFixed(2);
                        label.textContent = `${toSelect.options[toSelect.selectedIndex].text} (${to})`;
                    } else {
                        resultBox.value = 'N/A';
                    }
                })
                .catch(() => resultBox.value = 'Error');
        }

        amountInput.addEventListener('keyup', convert);
        fromSelect.addEventListener('change', convert);
        toSelect.addEventListener('change', convert);
    });
</script>

<?php
    return ob_get_clean();
}
add_shortcode('simple_currency_converter', 'scc_display_converter');

function scc_currency_options($selected = 'USD') {
    $currencies = array(
        'USD'=>'American Dollar', 'GBP'=>'British Pound', 'CAD'=>'Canadian Dollar', 'EUR'=>'Euro',
        'JPY'=>'Japanese Yen', 'CHF'=>'Swiss Franc', 'AUD'=>'Australian Dollar', 'AFN'=>'Afghan Afghani',
        'ALL'=>'Albanian Lek', 'DZD'=>'Algerian Dinar', 'AOA'=>'Angolan Kwanza', 'ARS'=>'Argentine Peso',
        'AMD'=>'Armenian Dram', 'AWG'=>'Aruban Florin', 'AZN'=>'Azerbaijani Manat', 'BSD'=>'Bahamian Dollar',
        'BHD'=>'Bahraini Dinar', 'BDT'=>'Bangladeshi Taka', 'BBD'=>'Barbados Dollar', 'BYR'=>'Belarusian Ruble',
        'BZD'=>'Belize Dollar', 'BMD'=>'Bermudian Dollar', 'BTC'=>'Bitcoin', 'BTN'=>'Bhutan Ngultrum',
        'BOB'=>'Bolivian Boliviano', 'BAM'=>'Bosnia-Herzegovina Convertible Mark', 'BWP'=>'Botswana Pula',
        'BRL'=>'Brazilian Real', 'BND'=>'Brunei Dollar', 'BGN'=>'Bulgarian Lev', 'BIF'=>'Burundi Franc',
        'KHR'=>'Cambodian Riel', 'CVE'=>'Cape Verde Escudo', 'KYD'=>'Cayman Islands Dollar', 'XAF'=>'CFA BEAC Franc',
        'CLP'=>'Chilean Peso', 'CNY'=>'Chinese Yuan Renminbi', 'COP'=>'Colombian Peso', 'CRC'=>'Costa Rican Colon',
        'HRK'=>'Croatian Kuna', 'CZK'=>'Czech Koruna', 'DKK'=>'Danish Krone', 'DJF'=>'Djibouti Franc',
        'DOP'=>'Dominican Peso', 'XCD'=>'East Caribbean Dollar', 'EGP'=>'Egyptian Pound', 'ERN'=>'Eritrean Nakfa',
        'ETB'=>'Ethiopian Birr', 'FJD'=>'Fiji Dollar', 'CDF'=>'Franc Congolais', 'XPF'=>'CFP Franc',
        'GMD'=>'Gambian Dalasi', 'GEL'=>'Georgian Lari', 'GHS'=>'Ghanaian Cedi', 'GIP'=>'Gibraltar Pound',
        'GTQ'=>'Guatemalan Quetzal', 'GNF'=>'Guinean Franc', 'GYD'=>'Guyanese Dollar', 'HKD'=>'Hong Kong Dollar',
        'HUF'=>'Hungarian Forint', 'ISK'=>'Iceland Krona', 'INR'=>'Indian Rupee', 'IDR'=>'Indonesian Rupiah',
        'IRR'=>'Iranian Rial', 'IQD'=>'Iraqi Dinar', 'ILS'=>'Israeli New Shekel', 'JMD'=>'Jamaican Dollar',
        'JOD'=>'Jordanian Dinar', 'KZT'=>'Kazakhstan Tenge', 'KES'=>'Kenyan Shilling', 'KRW'=>'Korean Won',
        'KWD'=>'Kuwaiti Dinar', 'KGS'=>'Kyrgyzstan Som', 'LAK'=>'Lao Kip', 'LBP'=>'Lebanese Pound',
        'LSL'=>'Lesotho Loti', 'LRD'=>'Liberian Dollar', 'LYD'=>'Libyan Dinar', 'MYR'=>'Malaysian Ringgit',
        'MVR'=>'Maldive Rufiyaa', 'MAD'=>'Moroccan Dirham', 'MMK'=>'Myanmar Kyat', 'NAD'=>'Namibian Dollar',
        'NPR'=>'Nepalese Rupee', 'ANG'=>'Netherlands Antillian Guilder', 'MZN'=>'Mozambican Metical',
        'TWD'=>'Taiwan Dollar', 'TRY'=>'Turkish Lira', 'NZD'=>'New Zealand Dollar', 'NIO'=>'Nicaraguan Cordoba Oro',
        'NGN'=>'Nigerian Naira', 'NOK'=>'Norwegian Krone', 'OMR'=>'Omani Rial', 'PKR'=>'Pakistan Rupee',
        'PAB'=>'Panamanian Balboa', 'PGK'=>'Papua New Guinea Kina', 'PYG'=>'Paraguay Guarani', 'PEN'=>'Peruvian Sol',
        'PHP'=>'Philippine Peso', 'PLN'=>'Polish Zloty', 'QAR'=>'Qatari Rial', 'RON'=>'Romanian Leu',
        'RUB'=>'Russian Ruble', 'RWF'=>'Rwanda Franc', 'SAR'=>'Saudi Riyal', 'RSD'=>'Serbian Dinar',
        'SCR'=>'Seychelles Rupee', 'SGD'=>'Singapore Dollar', 'ZAR'=>'South African Rand', 'SEK'=>'Swedish Krona',
        'CHF'=>'Swiss Franc', 'SYP'=>'Syrian Pound', 'THB'=>'Thai Baht', 'TTD'=>'Trinidad and Tobago Dollar',
        'TND'=>'Tunisian Dinar', 'UGX'=>'Uganda Shilling', 'UAH'=>'Ukraine Hryvnia', 'AED'=>'UAE Dirham',
        'UYU'=>'Uruguayan Peso', 'UZS'=>'Uzbekistan Sum', 'VND'=>'Vietnamese Dong', 'XOF'=>'CFA BCEAO Franc',
        'YER'=>'Yemeni Rial', 'ZMK'=>'Zambian Kwacha', 'ZWD'=>'Zimbabwe Dollar'
    );

    $options = '';
    foreach ($currencies as $code => $name) {
        $sel = ($code == $selected) ? 'selected' : '';
        $options .= "<option value='$code' $sel>$name</option>";
    }
    return $options;
}